/*! \file tlk_sclk_api_errors.h 
**********************************************************************************
*Title:                         Discretix Secured Clock Toolkit header file
*
* Filename:                     tlk_sclk_api_errors.h 
*
* Project, Target, subsystem:   Toolkit, Secure Clock
* 
* Created:                      10.09.2008
*
* Modified:                     10.09.2008
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2008 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_SCLK_API_ERRORS_H_
#define _TLK_SCLK_API_ERRORS_H_

#ifdef __cplusplus
extern "C" {
#endif

    /*! \brief Secure Clock Toolkit API Return Codes base                          **/
#define TLK_SCLK_RC_ERROR_BASE                           (0xBE000000UL)

    /*! \brief Operation completed successfully                                     **/
#define TLK_SCLK_RC_OK                                   (0x00000000UL)


    /*! \brief The error range number assigned to each module on its specified layer **/
#define TLK_SCLK_ERROR_MODULE_RANGE                      (0x00000100UL)

    /*! \brief Defines the module index for error mapping **/
#define TLK_SCLK_API_ERROR_IDX                           (0x00UL)
#define TLK_SCLK_MC_ERROR_IDX                            (0x001L)
#define TLK_SCLK_RTC_ERROR_IDX                           (0x002L)
#define TLK_SCLK_VNVS_ERROR_IDX                          (0x003L)

    /*! \brief            Defining the error spaces for each module on each layer              */
    /*! \brief  ------------------------------------------------------------------------------ */
    
    /*! \brief API module on the Secure Clock Toolkit layer base address - 0xBE000000 */
#define TLK_SCLK_API_MODULE_ERROR_BASE                  (TLK_SCLK_RC_ERROR_BASE + \
                                                         TLK_SCLK_ERROR_MODULE_RANGE * TLK_SCLK_API_ERROR_IDX)

    /*! \brief Master Clock module on the Secure Clock Toolkit layer base address - 0xBE000100 */
#define TLK_SCLK_MC_MODULE_ERROR_BASE                   (TLK_SCLK_RC_ERROR_BASE + \
                                                         TLK_SCLK_ERROR_MODULE_RANGE * TLK_SCLK_MC_ERROR_IDX)

    /*! \brief RTC module on the Secure Clock Toolkit layer base address - 0xBE000200 */
#define TLK_SCLK_RTC_MODULE_ERROR_BASE                  (TLK_SCLK_RC_ERROR_BASE + \
                                                         TLK_SCLK_ERROR_MODULE_RANGE * TLK_SCLK_RTC_ERROR_IDX)
   
    /*! \brief Virtual NVS module on the Secure Clock Toolkit layer base address - 0xBE000300 */
#define TLK_SCLK_VNVS_MODULE_ERROR_BASE                 (TLK_SCLK_RC_ERROR_BASE + \
                                                         TLK_SCLK_ERROR_MODULE_RANGE * TLK_SCLK_VNVS_ERROR_IDX)

    /************************************************************************/
    /* Error codes for different modules                                    */
    /************************************************************************/
    /************************************************************************/
    /* API  Module Errors                                                   */
    /************************************************************************/
    /*! \brief Operation failed                                  **/
#define TLK_SCLK_RC_ERROR_API_FAIL                      (TLK_SCLK_API_MODULE_ERROR_BASE+0x01)

    /*! \brief Operation failed -   Insufficient workspace given by user **/
#define TLK_SCLK_RC_ERROR_API_WORKSPACE                 (TLK_SCLK_API_MODULE_ERROR_BASE+0x02)

    /*! \brief Operation failed -   NULL Pinter workspace given by user **/
#define TLK_SCLK_RC_ERROR_API_WORKSPACE_NULL_PTR        (TLK_SCLK_API_MODULE_ERROR_BASE+0x03)

    /*! \brief Operation failed -   Unaligned workspace given by user   **/
#define TLK_SCLK_RC_ERROR_API_WORKSPACE_NOT_ALIGN       (TLK_SCLK_API_MODULE_ERROR_BASE+0x04)

    /*! \brief Operation failed -   Null pointer received a input       **/
#define TLK_SCLK_RC_ERROR_API_NULL_POINTER              (TLK_SCLK_API_MODULE_ERROR_BASE+0x05)

    /*! \brief Operation failed -   Problem in cookie generation        **/
#define TLK_SCLK_RC_ERROR_API_COOKIE_GENERATE_FAIL      (TLK_SCLK_API_MODULE_ERROR_BASE+0x07)

    /*! \brief Operation failed -   MAC calculation failed (Integrity problem) **/
#define TLK_SCLK_RC_ERROR_API_MAC_CALCULATE_FAIL        (TLK_SCLK_API_MODULE_ERROR_BASE+0x08)

    /*! \brief Operation failed -   User passed invalid format parameter value (Should be TLK_SCLK_SECONDS_SINCE_FORMAT or TLK_SCLK_DATE_TIME_FORMAT) **/
#define TLK_SCLK_RC_ERROR_API_INVALID_TIME_FORMAT       (TLK_SCLK_API_MODULE_ERROR_BASE+0x09)

    /*! \brief Operation failed -   Cookie validation failed (the master clock descriptor and service clock descriptor cookies are different) **/
#define TLK_SCLK_RC_ERROR_API_COOKIE_FAIL               (TLK_SCLK_API_MODULE_ERROR_BASE+0x0A)

    /*! \brief Operation failed -   Application Id given by user is differ than application id in descriptor **/
#define TLK_SCLK_RC_ERROR_API_APP_ID_INVALID            (TLK_SCLK_API_MODULE_ERROR_BASE+0x0B)
    
    /*! \brief Operation failed -  The toolkit initialization is done already.  **/
#define TLK_SCLK_RC_ERROR_API_TOOLKIT_ALREADY_INITIATED (TLK_SCLK_API_MODULE_ERROR_BASE+0x0C)

    /*! \brief Operation failed -  The toolkit is not initialized yet. Need to initialize**/
#define TLK_SCLK_RC_ERROR_API_TLK_SCLK_INACTIVE         (TLK_SCLK_API_MODULE_ERROR_BASE+0x0D)

    /*! \brief Operation failed -  The NVS configuration in config file was defined wrong**/
#define TLK_SCLK_RC_ERROR_API_NVS_CONFIGURATION         (TLK_SCLK_API_MODULE_ERROR_BASE+0x0E)

    /*! \brief Operation failed -  The RTC configuration in config file was defined wrong**/
#define TLK_SCLK_RC_ERROR_API_RTC_CONFIGURATION         (TLK_SCLK_API_MODULE_ERROR_BASE+0x0F)

    /*! \brief Operation failed -  Invalid (negative) maximum allowed drift given by user **/
#define TLK_SCLK_RC_ERROR_API_MAX_ALLOWED_DRIFT_INVALID (TLK_SCLK_API_MODULE_ERROR_BASE+0x10)

    /*! \brief Operation failed -  Invalid (negative) maximum revalidation period given by user **/
#define TLK_SCLK_RC_ERROR_API_MAX_REVALID_PERIOD_INVALID (TLK_SCLK_API_MODULE_ERROR_BASE+0x11)

    /*! \brief Operation failed -  Invalid read permission value given by user **/
#define TLK_SCLK_RC_ERROR_API_READ_PERMISSION_INVALID    (TLK_SCLK_API_MODULE_ERROR_BASE+0x12)

    /*! \brief Operation failed -  Secure Clock expired **/
#define TLK_SCLK_RC_ERROR_API_SECURE_CLOCK_EXPIRED       (TLK_SCLK_API_MODULE_ERROR_BASE+0x13)

	/*! \brief Operation failed -  Secure Clock expired **/
#define TLK_SCLK_RC_ERROR_API_SECURE_CLOCK_BAD_PWD       (TLK_SCLK_API_MODULE_ERROR_BASE+0x14)

    /************************************************************************/
    /* MC   Module Errors                                                   */
    /************************************************************************/
    /*! \brief Operation failed -  Service clock integrity compromised**/
#define TLK_SCLK_RC_ERROR_MC_SERVICE_CLK_INTEGRITY      (TLK_SCLK_MC_MODULE_ERROR_BASE+0x01)

        /*! \brief Operation failed -  MAC calculation of service clock failed**/
#define TLK_SCLK_RC_ERROR_MC_MAC_CALCULATE_FAIL         (TLK_SCLK_MC_MODULE_ERROR_BASE+0x02)

    /*! \brief Operation failed -  Problem in secrete key creation**/
#define TLK_SCLK_RC_ERROR_MC_SECRET_KEY_CREATE_FAIL     (TLK_SCLK_MC_MODULE_ERROR_BASE+0x03)

/*! \brief Operation failed -  Master clock integrity compromised**/
#define TLK_SCLK_RC_ERROR_MC_MASTER_CLK_TAMPERED        (TLK_SCLK_MC_MODULE_ERROR_BASE+0x04)

    /************************************************************************/
    /* RTC  Module Errors                                                   */
    /************************************************************************/

/*! \brief Operation failed -  Error in RTC time getting **/
#define TLK_SCLK_RC_ERROR_RTC_TIME_GET                  (TLK_SCLK_RTC_MODULE_ERROR_BASE+0x01)

/*! \brief Operation failed - Problem in converting the given time Generalized time to number of seconds since January 1, 1970. or conversion time that is represented as the number of seconds since January 1, 1970 to Generalized time **/
#define TLK_SCLK_RC_ERROR_RTC_TIME_CONVERT_FAIL         (TLK_SCLK_RTC_MODULE_ERROR_BASE+0x02)

/*! \brief Operation failed - Invalid time register address**/
#define TLK_SCLK_RC_ERROR_RTC_TIME_REG_ADDRESS_WRONG    (TLK_SCLK_RTC_MODULE_ERROR_BASE+0x03)

    /************************************************************************/
    /* VNVS Module Errors                                                   */
    /************************************************************************/

/*! \brief Operation failed -  In case of SST supports, Problem in session creation **/
#define TLK_SCLK_RC_ERROR_NVS_INIT_SESSION_FAIL         (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x01)

/*! \brief Operation failed -  In case of SST supports, Problem in transaction starting **/
#define TLK_SCLK_RC_ERROR_NVS_INIT_TRANSACTION_FAIL     (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x02)

/*! \brief Operation failed -  Problem in NVS file or external file opening **/
#define TLK_SCLK_RC_ERROR_NVS_INIT_FILE_OPEN_FAIL       (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x03)

/*! \brief Operation failed -  Cannot read master clock descriptor from VNVS **/
#define TLK_SCLK_RC_ERROR_NVS_READ_MC_DESC_FAIL         (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x04)

/*! \brief Operation failed -  Cannot write master clock descriptor to VNVS **/
#define TLK_SCLK_RC_ERROR_NVS_WRITE_MC_DESC_FAIL        (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x05)

/*! \brief Operation failed -  Cannot decrypt master clock descriptor **/
#define TLK_SCLK_RC_ERROR_NVS_DECRYPT_MC_DESC_FAIL      (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x06)

/*! \brief Operation failed -  Cannot encrypt master clock descriptor **/
#define TLK_SCLK_RC_ERROR_NVS_ENCRYPT_MC_DESC_FAIL      (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x07)

/*! \brief Operation failed -  In case of SST supports, Problem in session deletion **/
#define TLK_SCLK_RC_ERROR_NVS_TERM_SESSION_FAIL         (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x08)

/*! \brief Operation failed -  In case of SST supports, Problem in transaction ending **/
#define TLK_SCLK_RC_ERROR_NVS_TERM_TRANSACTION_FAIL     (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x09)

/*! \brief Operation failed -  Problem in NVS file or external file closing **/
#define TLK_SCLK_RC_ERROR_NVS_TERM_FILE_CLOSE_FAIL      (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x0A)

/*! \brief Operation failed -  Cannot wrap master clock descriptor secret key **/
#define TLK_SCLK_RC_ERROR_NVS_WRAP_MC_DESC_SECRET_KEY_FAIL      (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x0B)

/*! \brief Operation failed -  Cannot write master clock descriptor secret key to VNVS **/
#define TLK_SCLK_RC_ERROR_NVS_WRITE_MC_DESC_SECRET_KEY_FAIL     (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x0C)

/*! \brief Operation failed -  Cannot wrap Service clock descriptor secret key **/
#define TLK_SCLK_RC_ERROR_NVS_WRAP_SC_DESC_SECRET_KEY_FAIL      (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x0B)

/*! \brief Operation failed -  Cannot write Service clock descriptor secret key to VNVS **/
#define TLK_SCLK_RC_ERROR_NVS_WRITE_SC_DESC_SECRET_KEY_FAIL     (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x0C)

/*! \brief Operation failed -  Cannot read master clock descriptor secret key from VNVS **/
#define TLK_SCLK_RC_ERROR_NVS_READ_MC_DESC_SECRET_KEY_FAIL      (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x0D)

/*! \brief Operation failed -  Cannot unwrap master clock descriptor secret key **/
#define TLK_SCLK_RC_ERROR_NVS_UNWRAP_MC_DESC_SECRET_KEY_FAIL    (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x0E)

/*! \brief Operation failed -  Cannot read service clock descriptor secret key from VNVS **/
#define TLK_SCLK_RC_ERROR_NVS_READ_SC_DESC_SECRET_KEY_FAIL      (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x0F)

/*! \brief Operation failed -  Cannot unwrap service clock descriptor secret key **/
#define TLK_SCLK_RC_ERROR_NVS_UNWRAP_SC_DESC_SECRET_KEY_FAIL    (TLK_SCLK_VNVS_MODULE_ERROR_BASE+0x10)

#ifdef __cplusplus
}
#endif /*extern "C"*/

#endif /*_TLK_SCLK_API_ERRORS_H_*/
